#include "dm_console.h"
#include "dm_errors.h"
#include <linux/kernel.h>
#include <linux/string.h>

void DmConsoleInit(UINT32 lStackSize) {}

void DmConsolePrintf(const char *format, ...)
{
    va_list args;
    va_start(args, format);
    vprintk(format, args);
    va_end(args);
}

void DmConsolePrintError( UINT8 level, UINT8 subsystem, UINT8 errCode, UINT16 causeCode )
{
    /* Wonderfully general in the full spirit of Windows. */
    printk(KERN_EMERG "An error occurred.\n");
}

void DmConsoleLevelPrintf(UINT8 severity, const char *format, ...)
{
    /* Unfortunately, we need to add another copy for the printk. */
    const size_t bufSize = 256;
    char buf[bufSize];
    va_list args;
    /* Subtract the null character and level from the max size. len is the
     * maximum amount of the format string used. */
    int len = min(strlen(format), bufSize-(1+3));
    switch(severity) {
    case DM_ERROR_LEVEL_FATAL:  memcpy(buf, KERN_EMERG, 3);  break;
    case DM_ERROR_LEVEL_ERROR:    memcpy(buf, KERN_ERR, 3);    break;
    case DM_ERROR_LEVEL_WARNING:   memcpy(buf, KERN_WARNING, 3);break;
    case DM_ERROR_LEVEL_NOTICE: memcpy(buf, KERN_NOTICE, 3); break;
    case DM_ERROR_LEVEL_DEBUG:  memcpy(buf, KERN_DEBUG, 3);  break;
    default:
        memcpy(buf, KERN_INFO, 3);
    }
    memcpy(buf+3, format, len);
    buf[len+3] = '\0';
    va_start(args, format);
    vprintk(format, args);
    va_end(args);
}
